(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     24631,        712]
NotebookOptionsPosition[     22699,        650]
NotebookOutlinePosition[     23218,        669]
CellTagsIndexPosition[     23175,        666]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Schmidt-Cassegrain Telescope with a corrector after Cassegrain combination \
and spherical mirrors\
\>", "Title"],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["SchmidtCassegrainCBeforeSM",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["ft",
           FontWeight->Bold], Cell["total focal length"]},
         {Cell["em",
           FontWeight->Bold], Cell["back distance"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["Ni",
           FontWeight->Bold], Cell["refractive index of the lens"]},
         {Cell["\[CapitalDelta]",
           FontWeight->Bold], Cell[
          "distance between the corrector and the mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["SchmidtCassegrainCBeforeSMInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Schmidt-Cassegrain Telescope with a corrector after Cassegrain combination \
and spherical mirrors\
\>", "Title"],

Cell["\<\
The Schmidt-Cassegrain telescope is formed by a Schmidt corrector placed in \
front of a Cassegrain combination. With this optical scheme it is possible to \
eliminate spherical aberration, coma, and astigmatism. The cromatism is \
negligible. The designe starts with the paraxial data of the Cassegrain \
combination:\
\>", "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f1", " ", "=", " ", 
    RowBox[{"primary", " ", "focal", " ", "lenght"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"ft", " ", "=", " ", 
   RowBox[{"total", " ", "focal", " ", "length"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", " ", "=", 
   RowBox[{"back", " ", "distance"}]}], ";"}]}], "DisplayFormula"],

Cell["and it supplies the following quantities", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"em", "/", "f1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"M", "=", 
   RowBox[{"ft", "/", "f1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Beta]", "=", 
   FractionBox[
    RowBox[{"M", "-", "\[Alpha]"}], 
    RowBox[{"M", "+", "1"}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"co", "=", 
   RowBox[{"1", "-", "\[Beta]"}]}], ";"}], "\n", 
 RowBox[{"\[Gamma]", "=", 
  FractionBox[
   RowBox[{"2", " ", "M", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
   RowBox[{"1", "-", 
    SuperscriptBox["M", "2"]}]]}]}], "DisplayFormula"],

Cell["\<\
Then, \[Alpha]  and M are taken as the fundamental  variables and the \
following quantities are introduced:\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"R1", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "f1"}], " ", "=", " ", 
    RowBox[{"primary", " ", "radius"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"R2", " ", "=", " ", 
   RowBox[{
    RowBox[{"\[Gamma]", " ", "f1"}], " ", "=", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "M", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["M", "2"]}]], "f1"}], "=", " ", 
     RowBox[{"secondary", " ", "radius", " ", 
      RowBox[{"(", 
       RowBox[{"\[Gamma]", "<", "0"}], ")"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s12", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", "f1"}], " ", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"M", "-", "\[Alpha]"}], 
        RowBox[{"M", "+", "1"}]]}], "f1"}], "=", " ", 
     RowBox[{
     "distance", " ", "of", " ", "the", " ", "secondary", " ", "from", " ", 
      "primary", " ", 
      RowBox[{"(", 
       RowBox[{"\[Beta]", ">", "0"}], ")"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"K1", " ", "=", " ", 
   RowBox[{"conic", " ", "constant", " ", "of", " ", "primary"}]}], 
  ";"}], "\n", 
 RowBox[{"K2", "  ", "=", " ", 
  RowBox[{"conic", " ", "constant", " ", "of", " ", 
   RowBox[{"secondary", "."}]}]}]}], "DisplayFormula"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SchmidtCassegrainCBeforeSM Examples", "Title"],

Cell["\<\
To use the SchmidtCassegrainCBeforeSM function you can either use directly \
the function SchmidtCassegrainCBeforeSM[f1, ft, em, diam, Ni, \
\[CapitalDelta], \[Theta]] or use the interactive panel created by calling \
the function SchmidtCassegrainCBeforeSMInputPanel[]. It \
let\[CloseCurlyQuote]s you to set input values and then call the \
SchmidtCassegrainCBeforeSM function. Moreover, it helps to load examples from \
the saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "500."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ft", "=", "2000."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"em", "=", "200."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "100."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ni", "=", "1.518722"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.5"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SchmidtCassegrainCBeforeSM", "[", 
    RowBox[{
    "f1", ",", "ft", ",", "em", ",", "diam", ",", "Ni", ",", 
     "\[CapitalDelta]", ",", "\[Theta]"}], "]"}], ";"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"SchmidtCassegrainCBeforeSM", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", "diam", ",", "Ni", ",", "\[CapitalDelta]",
     ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"SchmidtCassegrainCBeforeSM", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", "diam", ",", "Ni", ",", "\[CapitalDelta]",
     ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"SchmidtCassegrainCBeforeSM", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", "diam", ",", "Ni", ",", "\[CapitalDelta]",
     ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"SchmidtCassegrainCBeforeSM", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", "diam", ",", "Ni", ",", "\[CapitalDelta]",
     ",", "\[Theta]", ",", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "600."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ft", "=", "2200."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"em", "=", "200."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "100."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ni", "=", 
   RowBox[{"Ni", "=", "1.518722"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.35"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SchmidtCassegrainCBeforeSM", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", "diam", ",", "Ni", ",", "\[CapitalDelta]",
     ",", "\[Theta]"}], "]"}], ";"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<SchmidtCassegrainCBeforeSM\>\"", 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"SchmidtCassegrainCBeforeSM", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"SchmidtCassegrainCBeforeSMInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1920, 992},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> True}},
TrackCellChangeTimes->False,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 123, 3, 71, "Title"],
Cell[CellGroupData[{
Cell[727, 29, 35, 0, 43, "Subsection"],
Cell[765, 31, 121, 2, 46, "Text"],
Cell[889, 35, 1716, 45, 345, "Text"],
Cell[2608, 82, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4755, 140, 40, 0, 43, "Subsection"],
Cell[4798, 142, 262, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5097, 153, 40, 0, 43, "Subsection"],
Cell[5140, 155, 111, 2, 46, "Text"],
Cell[5254, 159, 3193, 83, 551, "Text"],
Cell[8450, 244, 2296, 56, 473, "Text"],
Cell[10749, 302, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14263, 397, 123, 3, 71, "Title"],
Cell[14389, 402, 357, 7, 70, "Text"],
Cell[14749, 411, 358, 10, 70, "DisplayFormula"],
Cell[15110, 423, 56, 0, 46, "Text"],
Cell[15169, 425, 609, 21, 147, "DisplayFormula"],
Cell[15781, 448, 132, 3, 46, "Text"],
Cell[15916, 453, 1416, 44, 149, "DisplayFormula"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17369, 502, 52, 0, 71, "Title"],
Cell[17424, 504, 514, 9, 94, "Text"],
Cell[17941, 515, 527, 14, 165, "Input"],
Cell[18471, 531, 482, 12, 55, "Input"],
Cell[18956, 545, 512, 12, 55, "Input"],
Cell[19471, 559, 539, 12, 55, "Input"],
Cell[20013, 573, 689, 15, 55, "Input"],
Cell[20705, 590, 803, 19, 55, "Input"],
Cell[21511, 611, 553, 15, 165, "Input"],
Cell[22067, 628, 208, 5, 32, "Input"],
Cell[22278, 635, 65, 0, 46, "Text"],
Cell[22346, 637, 100, 2, 32, "Input"],
Cell[22449, 641, 74, 1, 32, "Input"],
Cell[22526, 644, 70, 0, 46, "Text"],
Cell[22599, 646, 84, 1, 32, "Input"]
}, Open  ]]
}
]
*)

